{{-- filepath: resources/views/admin/schReports/class_list.blade.php --}}
@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="card-header">
            Список класів
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Клас</th>
                        <th>Дії</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($schclasses as $class)
                        <tr>
                            <td>{{ $class->name }}</td>
                            <td>
                                @can('sch_report_show')
                                    <a class="btn btn-xs btn-primary"
                                        href="{{ route('admin.sch-reports.create', ['class_id' => $class->id]) }}">
                                        Додати репорт
                                    </a>
                                @endcan
                                @can('sch_report_edit')
                                    <a class="btn btn-xs btn-info"
                                        href="{{ route('admin.sch-reports.index', ['class_id' => $class->id]) }}">
                                        Переглянути репорти
                                    </a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
